package pl.alx.kurs.adaptery;

import android.database.DataSetObserver;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.ListAdapter;
import android.widget.TextView;

public class MnozenieAdapter implements ListAdapter {

	private LayoutInflater inflater;
	
	public MnozenieAdapter(LayoutInflater inflater) {
		this.inflater = inflater;
	}

	public void registerDataSetObserver(DataSetObserver observer) { }
	public void unregisterDataSetObserver(DataSetObserver observer) { }

	public int getCount() {
		return 100 * 100;
	}

	public Object getItem(int position) {
		int a = position / 100;
		int b = position % 100;
		return a + " x " + b + " = " + (a * b);
	}

	public long getItemId(int position) {
		return position;
	}

	public boolean hasStableIds() {
		return true;
	}

	public View getView(int position, View convertView, ViewGroup parent) {
		int a = position / 100;
		int b = position % 100;
		String opis = a + " x " + b + " = " + (a * b);
		View wiersz = inflater.inflate(R.layout.wiersz_tabliczki, null);
		TextView tva = (TextView) wiersz.findViewById(R.id.a);
		TextView tvb = (TextView) wiersz.findViewById(R.id.b);
		TextView tvc = (TextView) wiersz.findViewById(R.id.c);
		tva.setText("" + a);
		tvb.setText("" + b);
		tvc.setText(opis);
		return wiersz;
	}

	public int getItemViewType(int position) {
		return 0;
	}

	public int getViewTypeCount() {
		return 1;
	}

	public boolean isEmpty() {
		return false;
	}

	public boolean areAllItemsEnabled() {
		return true;
	}

	public boolean isEnabled(int position) {
		return true;
	}

}
